<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Warehouse extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'code' => 'nullable',
        'name' => 'nullable',
        'purpose' => 'required|in:storage,sales,both',
        'status' => 'required',
        'branch_ids' => 'required|array',
        'branch_ids.*' => 'required|exists:branches,id',
    ];


    protected $fillable = [
        'code',
        'name',
        'status',
        'type',
        'purpose',
        'company_id',
        'address',
    ];

    protected $translatable = [
        'name'
    ];

    public function branches()
    {
        return $this->belongsToMany(Branch::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function products()
    {
        return $this->hasMany(ProductWarehouse::class);
    }

    public function bills()
    {
        return $this->hasMany(Bill::class);
    }

    public function dismissalNotice()
    {
        return $this->hasMany(DismissalNotice::class);
    }
}
