<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * This is used by Laravel authentication to redirect users after login.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * The controller namespace for the application.
     *
     * When present, controller route declarations will automatically be prefixed with this namespace.
     *
     * @var string|null
     */
    // protected $namespace = 'App\\Http\\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        $this->configureRateLimiting();

        $this->routes(function () {
            Route::prefix('api')
                ->middleware(['api', 'lang'])
                ->namespace($this->namespace)
                ->group(base_path('routes/api.php'));

            Route::prefix('api/v1/online')
                ->middleware(['api', 'secret-key-auth'])
                ->namespace($this->namespace)
                ->group(base_path('routes/v1/online.php'));

            Route::prefix('api/client-api')
                ->middleware(['api', 'auth:company', 'secret-key-auth', 'lang'])
                ->namespace($this->namespace)
                ->group(base_path('routes/client-api.php'));

            Route::prefix('api/branches')
                ->middleware(['api', 'auth:company', 'secret-key-auth', 'lang'])
                ->namespace($this->namespace)
                ->group(base_path('routes/branch.php'));

            Route::prefix('api/employees')
                ->middleware(['api', 'auth:company', 'secret-key-auth', 'lang'])
                ->namespace($this->namespace)
                ->group(base_path('routes/employee.php'));

            Route::prefix('api/employees-api')
                ->middleware(['api', 'lang'])
                ->namespace($this->namespace)
                ->group(base_path('routes/employee-api.php'));

            Route::prefix('api/companies')
                ->middleware(['api', 'auth:company', 'secret-key-auth', 'lang'])
                ->namespace($this->namespace)
                ->group(base_path('routes/company.php'));

            Route::prefix('api/admins')
                ->middleware([
                    'api',
                ])
                ->namespace($this->namespace)
                ->group(base_path('routes/admin.php'));

            Route::middleware('web')
                ->namespace($this->namespace)
                ->group(base_path('routes/web.php'));
        });
    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by(optional($request->user())->id ?: $request->ip());
        });
    }
}
