<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class AttendanceDayRule implements Rule
{
    public $message = "";
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $validDays = ['saturday', 'sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday'];

        // Create an array of day names from the input array
        $dayNames = array_map(function ($day) {
            return $day['name'];
        }, $value);

        // Check if all days exist
        if (count(array_diff($validDays, $dayNames)) > 0 || count(array_diff($dayNames, $validDays)) > 0) {
            $this->message = 'You must send all days.';
            return false;
        }

        foreach ($value as $day) {
            if (isset($day['start']) && !isset($day['end'])) {
                $this->message = 'You must send the start.';
                return false;
            }

            if (isset($day['end']) && !isset($day['start'])) {
                $this->message = 'You must send the end.';
                return false;
            }

            if (!isset($day['start']) && !isset($day['end'])) {
                if (!isset($day['vacation']) || !$day['vacation']) {
                    $this->message = 'Having vacation?';
                    return false;
                }
            }
        }

        return true;
    }


    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return $this->message;
    }
}
