<?php

namespace App\Rules;


use Illuminate\Contracts\Validation\Rule;

class UniqueCompanyPhone implements Rule
{
    public function __construct(public $model, public $currentId = null)
    {
    }

    public function passes($attribute, $value)
    {
        $query = $this->model::where('company_id', auth()->id())->where('phone', $value);
        if (!is_null($this->currentId)) {
            $query->where('id', '!=', $this->currentId);
        }
        return !$query->exists();
    }

    public function message()
    {
        return 'This phone number already been used before.';
    }
}
