<?php

namespace App\Rules;

use App\Models\Company;
use Illuminate\Contracts\Validation\Rule;

class UniqueCurrencyMainType implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(public Company $company)
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if ($value == 1) {
            $type_main_count = $this->company->currencies->where('type', 1)->count();
            return $type_main_count < 1;
        }
        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'You already have a main currency.';
    }
}
