<?php

namespace App\Rules;

use App\Models\Client;
use App\Http\Helper\CompanyHelper;
use Illuminate\Contracts\Validation\Rule;

class UniqueSpecialClient implements Rule
{
    protected $companyId;

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->companyId = CompanyHelper::getCompany(request())->id;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!$value) {
            return true;
        }

        $existingSpecialClient = Client::where('company_id', $this->companyId)
            ->where('special', true)
            ->first();

        $routeClient = request()->route()->client;

        if (!$routeClient && !$existingSpecialClient) {
            return true;
        }

        return  $existingSpecialClient->is($routeClient);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'There can be only one special client for this company.';
    }
}
