<?php

namespace App\Rules;

use App\Http\Helper\CompanyHelper;
use Illuminate\Contracts\Validation\Rule;

class ValidSellNatureRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return CompanyHelper::getCompany(request())->sellNatures()->where('main_sell_natures.id',  $value)->exists();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Invalid sell nature.';
    }
}
