<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Branch>
 */
class BranchFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $i= rand(1, 100);
        return [
            'place' => [
                'ar' => 'فرع ' . $i,
                'en' => 'branch' . $i
            ],
            'phone_one' => fake()->phoneNumber(),
            'phone_two' => fake()->phoneNumber(),
            'email' => fake()->email(),
            'website' => fake()->url(),
            'manager_fname' => fake()->firstName(),
            'manager_lname' => fake()->lastName(),
            'gender' => rand(1, 2),
            'home_service' => rand(1, 2),
            'beauty_expert' => rand(1, 2),
            'delivers' => rand(1, 2),
            'address_id' => rand(1, 10),
            // 'employee_count_id' => rand(1, 10),
            // 'work_type_id' => rand(1, 10),
        ];


    }
}
