<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Category>
 */
class CategoryFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'type' => $this->faker->randomElement(['products_category', 'services_category']),
            'name' => [
                'en' => $this->faker->name(),
                'ar' => $this->faker->name()
            ],
            'company_id' => rand(100, 111),
            'description' => [
                'en' => $this->faker->paragraph(),
                'ar' => $this->faker->paragraph()
            ],
            'internet_description' => $this->faker->paragraph(),
            'status' => $this->faker->boolean(),
            'fast' => $this->faker->boolean(),
        ];
    }
}
