<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBillServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bill_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_id')->constrained();
            $table->foreignId('branch_id')->constrained();
            $table->foreignId('bill_id')->constrained();
            $table->enum('discount_type', ['percentage', 'number']);
            $table->unsignedInteger('demount_amount');
            $table->unsignedInteger('quantity');
            $table->date('date');
            $table->time('starts_at');
            $table->boolean('tax_included')->default(false);
            $table->foreignId('tax_id')->nullable()->constrained();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bill_services');
    }
}
