<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExtraDataToClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->json('medical')->after('special')->nullable();
            $table->json('medical_history')->after('medical')->nullable();
            $table->json('contact_info')->after('medical_history')->nullable();
            $table->json('extra_data')->after('contact_info')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->dropColumn('medical');
            $table->dropColumn('medical_history');
            $table->dropColumn('contact_info');
            $table->dropColumn('extra_data');
        });
    }
}
