<?php

namespace Database\Seeders;

use App\Models\BranchMainSettings;
use Illuminate\Database\Seeder;

class BranchMainSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $main_settings_names = [
            [
                'ar' => 'ساعات العمل',
                'en' => 'Work hours',
            ],
            [
                'ar' => 'إعدادات المبيعات',
                'en' => 'Sales settings',
            ],
            [
                'ar' => 'إعدادات الموظفين',
                'en' => 'Staff settings',
            ],
            [
                'ar' => 'إعدادات إشعارات طلبات الأذونات',
                'en' => 'Permission request notification settings',
            ],
            [
                'ar' => 'إعدادات حجوزات العملاء',
                'en' => 'Customer reservations settings',
            ],
            [
                'ar' => 'إعدادات نطام قائمة إنتظار العملاء',
                'en' => 'Customer queue system settings',
            ],
            [
                'ar' => 'إعدادات نظام تكويد الفواتير',
                'en' => 'Billing system settings',
            ],
            [
                'ar' => 'إعدادات التحديث الآلي',
                'en' => 'Automatic update settings',
            ],
            [
                'ar' => 'إعدادات اليوميات و الورديات',
                'en' => 'Diary and shift settings',
            ],
            [
                'ar' => 'إعدادات الحسابات',
                'en' => 'Accounts settings',
            ],
            [
                'ar' => 'إعدادات الضرائب',
                'en' => 'Tax settings',
            ],
            [
                'ar' => 'إعدادات التنبيهات',
                'en' => 'Alerts settings',
            ],
            [
                'ar' => 'إعدادات الجلسات',
                'en' => 'Session settings',
            ],
            [
                'ar' => 'إعدادات إشتراك الصالة الرياضية',
                'en' => 'Gym subscription settings',
            ],

            [
                'ar' => 'إعدادات العملاء',
                'en' => 'Customer settings',
            ],
            [
                'ar' => 'إعدادات الحجز',
                'en' => 'Booking settings',
            ],
            [
                'ar' => 'نقاط الولاء',
                'en' => 'Loyalty points',
            ],
            [
                'ar' => 'إعدادات الإحصائيات',
                'en' => 'Statistics settings',
            ],
            [
                'ar' => 'إعدادات الخدمات',
                'en' => 'Services settings',
            ],
            [
                'ar' => 'إعدادات المنتجات',
                'en' => 'Product settings',
            ],
            [
                'ar' => 'إعدادات الطباعة',
                'en' => 'Print settings',
            ],
            [
                'ar' => 'المميزات',
                'en' => 'Advantages',
            ],
            [
                'ar' => 'إعدادات عامة',
                'en' => 'General settings',
            ],


        ];

        foreach ($main_settings_names as $value) {
            BranchMainSettings::create([
                'name' => $value,
            ]);
        }
    }
}
