<?php

namespace Database\Seeders;

use App\Models\BranchSubSettings;
use Illuminate\Database\Seeder;

class BranchSubSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $sub_settings = [
            [
                'name' => [
                    'ar' => 'السبت',
                    'en' => 'Saturday',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 1,
            ],
            [
                'name' => [
                    'ar' => 'الأحد',
                    'en' => 'Sunday',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 1,
            ],
            [
                'name' => [
                    'ar' => 'الاثنين',
                    'en' => 'Monday',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 1,
            ],
            [
                'name' => [
                    'ar' => 'الثلاثاء',
                    'en' => 'Tuesday',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 1,
            ],
            [
                'name' => [
                    'ar' => 'الأربعاء',
                    'en' => 'Wednesday',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 1,
            ],
            [
                'name' => [
                    'ar' => 'الخميس',
                    'en' => 'Thursday',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 1,
            ],
            [
                'name' => [
                    'ar' => 'الجمعة',
                    'en' => 'Friday',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 1,
            ],
            [
                'name' => [
                    'ar' => 'التقريب لأقرب رقم صحيح',
                    'en' => 'Rounding to the nearest whole number',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتعديل الإجمالي للاصناف في العمليات',
                    'en' => 'Allow modifying the total for items in operations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتسجيل الارقام الخاطئة في عمليات البيع',
                    'en' => 'Allowing incorrect numbers to be recorded in sales transactions',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'يجب دفع العناصر المنتهية العمل في دفع الحجز',
                    'en' => 'Finished items must be paid for at the booking payment',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام الاكراميات في الفاتورة',
                    'en' => 'Allow gratuities to be used on the bill',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام البرومو كود',
                    'en' => 'Allow the use of promo code',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإحتساب العمولات في فواتير المبيعات',
                    'en' => 'Allowing commissions to be calculated in sales invoices',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام الخصم علي الإجمالي الصافي في المبيعات',
                    'en' => 'Allow the use of discount on the net total in sales',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'عند الغاء/حذف عنصر منهي العمل به من عملية البيع لعميل لدفع الحجز',
                    'en' => 'When canceling/deleting a finished item from the sales process to a customer to pay the reservation',
                ],
                'rules' => 'required|between:0,1',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'إتاحة التعديل علي عمليات البيع',
                    'en' => 'Providing modification to sales operations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'إتاحة التعديل علي العملاء في عمليات البيع',
                    'en' => 'Allowing customers to modify sales operations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'إتاحة التعديل علي موظفي العناصر في عمليات البيع',
                    'en' => 'Providing modification to employee employees in sales operations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'إتاحة التعديل علي طرق الدفع في عمليات البيع',
                    'en' => 'Providing modification to payment methods in sales operations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'إتاحة التعديل علي تاريخ بداية و نهاية إشتراك الصالة الرياضية في عمليات البيع',
                    'en' => 'Providing the ability to modify the start and end dates of the gym’s subscription to sales operations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'إتاحة التعديل علي أيام الأسبوع لإشتراك الصالة الرياضية في عمليات البيع',
                    'en' => 'Allowing the amendment to the days of the week for the gym’s participation in sales operations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'إتاحة التعديل علي فروع الحضور لإشتراك الصالة الرياضية في عمليات البيع',
                    'en' => 'Providing the amendment to the attendance branches for the gym’s participation in sales operations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 2,
            ],
            [
                'name' => [
                    'ar' => 'النسبة الافتراضية المدفوعة مقابل الخدمات المنجزة',
                    'en' => 'The default percentage paid for services performed',
                ],
                'rules' => 'required|integer',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'النسبة الافتراضية المدفوعة للمنتجات المباعة',
                    'en' => 'The default percentage paid for products sold',
                ],
                'rules' => 'required|integer',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'عدد الأذونات لكل موظف',
                    'en' => 'Number of permissions per employee',
                ],
                'rules' => 'required|integer',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'اقصي عدد ساعات لكل إذن',
                    'en' => 'Maximum number of hours per permission',
                ],
                'rules' => 'required|integer',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'السماح بلإضافي',
                    'en' => 'Allow additional',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'إحتساب عمولة التارجت في حدود مواعيد العمل فقط',
                    'en' => 'Target commission is calculated within working hours only',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'السماح بالعمولة من العملاء',
                    'en' => 'Allow commission from clients',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'السماح باحتساب عمولات لموظفي الأستقبال',
                    'en' => 'Allowing the calculation of commissions for reception staff',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'طريقة تسجيل حضور الموظفين',
                    'en' => 'How to record employee attendance',
                ],
                'rules' => 'required|between:0,1',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'عدد الموظفين المعروضين في المبيعات و الحجوزات ',
                    'en' => 'Number of employees displayed in sales and reservations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض الموظفين الأكثر إستخداما في المبيعات و الحجوزات',
                    'en' => 'Allows display of employees most frequently used in sales and reservations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'طريقة ترتيب الموظفين',
                    'en' => 'How to arrange employees',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 3,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام طلبات الأذونات',
                    'en' => 'Allow the use of permission requests',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتطبيق الخصم بطلب إذن علي الفاتورة',
                    'en' => 'Allow the discount to be applied by requesting permission on the invoice',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض المستخدم الذي وافق علي طلب إذن الخصم في الفاتوره',
                    'en' => 'Allow display of the user who approved the discount authorization request on the invoice',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتطبيق مرتجع البيع بطلب إذن',
                    'en' => 'Allow sales returns to be applied by requesting permission',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض المستخدم الذي وافق علي طلب إذن مرتجع البيع في الفاتوره',
                    'en' => 'Allow the user who has approved the sale return permission request to be displayed on the invoice',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتطبيق تعديل الفاتورة بطلب إذن',
                    'en' => 'Allow the invoice modification application to request permission',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتطبيق إلغاء الحجز بطلب إذن',
                    'en' => 'Allow the reservation cancellation app to request permission',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام أصوات إشعارات طلبات الأذونات',
                    'en' => 'Allow the use of notification sounds for permission requests',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'نوع أصوات تنبيهات الطلبات',
                    'en' => 'Type of order alert sounds',
                ],
                'rules' => 'required|between:0,1',
                'branch_main_settings_id' => 4,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإضافة رصيد حجوزات العملاء في جلاميرا بيزنس',
                    'en' => 'Allowing customers to add credit to Glamera Business reservations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 5,
            ],
            [
                'name' => [
                    'ar' => 'عند حدوث خطأ في التعامل مع رصيد حجوزات العملاء',
                    'en' => 'When an error occurs in dealing with the balance of customer reservations',
                ],
                'rules' => 'required|between:0,1',
                'branch_main_settings_id' => 5,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام نطام قائمة إنتظار العملاء',
                    'en' => 'Allowing the use of the customer waiting list system',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 6,
            ],
            [
                'name' => [
                    'ar' => 'النوع الذي يعتمد عليه نظام قائمة انتظار العملاء',
                    'en' => 'The type on which the customer queue system is based',
                ],
                'rules' => 'required|between:0,1',
                'branch_main_settings_id' => 6,
            ],
            [
                'name' => [
                    'ar' => 'بداية ترقيم قائمة إنتظار العملاء',
                    'en' => 'Beginning of customer waiting list numbering',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 6,
            ],
            [
                'name' => [
                    'ar' => 'إستخدام نظام تكويد العمليات',
                    'en' => 'Using a process coding system',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 7,
            ],
            [
                'name' => [
                    'ar' => 'تهيئة أكواد العمليات السابقة',
                    'en' => 'Initialize previous operation codes',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 7,
            ],
            [
                'name' => [
                    'ar' => 'السماح باستخدام التحديث التلقائي في شاشة تقويم الحجوزات',
                    'en' => 'Allow automatic updating in the reservations calendar screen',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 8,
            ],
            [
                'name' => [
                    'ar' => 'السماح باستخدام التحديث التلقائي في شاشة قائمة الحجوزات',
                    'en' => 'Allow automatic updating on the reservations list screen',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 8,
            ],
            [
                'name' => [
                    'ar' => 'عرض الارصدة السابقة لطريقة الدفع الكاش في اليومية و الوردية',
                    'en' => 'View previous balances for the cash payment method on the daily and shift basis',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 9,
            ],
            [
                'name' => [
                    'ar' => 'عرض الارصدة السابقة لطرق الدفع الاخري ( غير الكاش ) في اليومية و الوردية',
                    'en' => 'View the previous balances of other payment methods (other than cash) in the daily and shift periods',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 9,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإغلاق اليومية آليا بعد إغلاق كل الورديات',
                    'en' => 'Allow the journal to be closed automatically after all shifts are closed',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 9,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتعديل أرصدة الورديات بعد طلب الإغلاق',
                    'en' => 'Allow shift balances to be modified after a shutdown request',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 9,
            ],
            [
                'name' => [
                    'ar' => 'لمستخدمين المسموح لهم تعديل أرصدة الورديات',
                    'en' => 'Users allowed to modify shift balances',
                ],
                'rules' => 'required|between:0,3',
                'branch_main_settings_id' => 9,
            ],
            [
                'name' => [
                    'ar' => 'عدم السماح بفتح يومية بتاريخ مستقبلي ( تاريخ قادم )',
                    'en' => 'Do not allow opening a journal with a future date (upcoming date)',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 9,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام القيود',
                    'en' => 'Allow the use of restrictions',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 10,
            ],
            [
                'name' => [
                    'ar' => 'إستخدام ضرائب المبيعات',
                    'en' => 'Use of sales taxes',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'معدل ضريبة المبيعات',
                    'en' => 'Sales tax rate',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'إستخدام ضرائب المشتريات',
                    'en' => 'Use of purchase taxes',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'معدل ضريبة المشتريات',
                    'en' => 'Purchases tax rate',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'السعر يشمل الضريبة',
                    'en' => 'Price includes tax',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'طريقة تطبيق الضرائب',
                    'en' => 'How taxes are applied',
                ],
                'rules' => 'required|between:0,1',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'رقم السجل التجاري',
                    'en' => 'Commercial Registration No',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'رقم التسجيل الضريبي',
                    'en' => 'Tax registration number',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'ظهور رقم السجل التجاري فى شاشة الطباعة',
                    'en' => 'The commercial registration number appears on the print screen',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'ظهور رقم التسجيل الضريبي فى شاشة الطباعة',
                    'en' => 'The tax registration number appears on the print screen',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 11,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإرسال إشعارات بطلبيات البضاعة',
                    'en' => 'Allow sending notifications of merchandise orders',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 12,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإرسال إشعارات عن حد الطلب للمنتجات',
                    'en' => 'Allow notifications of order limit for products',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 12,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإرسال إشعارات صرف العهد للموظفين',
                    'en' => 'Allow sending covenant disbursement notices to employees',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 12,
            ],
            [
                'name' => [
                    'ar' => 'إستخدام الجلسات',
                    'en' => 'Session Usage',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'إستخدام جلسات الليزر',
                    'en' => 'Laser Session Usage',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام الخدمة بالمنطقة في الخدمات',
                    'en' => 'Allow Service Usage in the Area for Services',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'السماح بالتعديل على أسعار جلسات الخدمات بالمنطقة في الحجوزات والمبيعات',
                    'en' => 'Allow Modification of Service Session Prices in Reservations and Sales in the Area',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'سعر النبضة',
                    'en' => 'Pulse Rate',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'السماح بالتعديل على سعر النبضات في الحجوزات و المبيعات',
                    'en' => 'Allow Modification of Pulse Rate in Reservations and Sales',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'معامل عدد النبضات للطبيب',
                    'en' => 'Doctor\'s Pulse Count Factor',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'معامل عدد النبضات للطبيب في حالة إستخدام الخدمة بالمنطقة',
                    'en' => 'Doctor\'s Pulse Count Factor when Using the Service in the Area',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'معامل الإيراد الفعلي للنبضات للطبيب - نسبة',
                    'en' => 'Actual Revenue Factor for Doctor\'s Pulses - Percentage',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 13,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام إشتراك الصالة الرياضية',
                    'en' => 'Allow the Use of Gym Membership',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام الأيام المجمدة',
                    'en' => 'Allow the Use of Frozen Days',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'السماح بالإشتراك بعضوية صالة رياضية مختلفة لنفس الفترة لنفس العميل',
                    'en' => 'Allow Subscribing to a Different Gym Membership for the Same Period for the Same Customer',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'بداية ترقيم كود عضوية الصالة الرياضية',
                    'en' => 'Start of Gym Membership Code Numbering',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتغيير / تعديل العميل لإشتراك الصالة الرياضية',
                    'en' => 'Allow Changing / Editing the Customer for Gym Membership',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام تنبيهات العملاء عند إقتراب إنتهاء إشتراك الصالة الرياضية',
                    'en' => 'Allow Using Customer Notifications When Gym Membership Is About to Expire',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'عدد مرات التكرار',
                    'en' => 'Number of Repeats',
                ],
                'rules' => 'required|between:0,2',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'تنبيه كل',
                    'en' => 'alert every',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'طريقة التنبيه',
                    'en' => 'Alert Method',
                ],
                'rules' => 'required|between:0,3',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'أضف قالب الرسالة الإفتراضي آليًا وتعيينه كقالب الرسالة بدلاً من اختياره',
                    'en' => 'Automatically Add the Default Message Template and Set It as the Message Template Instead of Choosing It',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 14,
            ],
            [
                'name' => [
                    'ar' => 'التعامل مع العملاء المحظورين',
                    'en' => 'Dealing with blocked clients',
                ],
                'rules' => 'required|between:0,1',
                'branch_main_settings_id' => 15,
            ],
            [
                'name' => [
                    'ar' => 'تحضير يدوي',
                    'en' => 'Manual Attendance ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 15,
            ],
            [
                'name' => [
                    'ar' => 'تحضير بملف اكسل',
                    'en' => 'In excel file Attendance ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 15,
            ],
            [
                'name' => [
                    'ar' => 'تطبيق مقدم الحجز علي',
                    'en' => 'Booking provider application on',
                ],
                'rules' => 'required|between:0,2',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'اقل نسبة لمقدم الحجز',
                    'en' => 'The lowest percentage for the reservation deposit',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'تحويل الحجز إلى مؤكد تلقائيًا عند دفع مقدم الحجز',
                    'en' => 'Convert your reservation to confirmed automatically when you pay the reservation deposit ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'تحويل الحجز الي انتهي تلقائيا عند الدفع',
                    'en' => 'Convert your reservation to automatically expire upon payment ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'إنتهاء العمل في خدمات الحجز عند انشاء الحجز',
                    'en' => 'Work on reservation services ends when the reservation is created ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'الحالة الافتراضية للحجز عند انشاء الحجز',
                    'en' => 'The default status of the reservation when creating the reservation ',
                ],
                'rules' => 'required|between:0,7',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'تحويل خدمات و جلسات خدمات الحجز الي انتهي العمل عند تحويل حالة الحجز الي انتهي العمل',
                    'en' => 'Converting booking services and sessions to Completed when converting the reservation status to Completed',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'السماح بالحجز في وقت و تاريخ سابق',
                    'en' => 'Allowing reservations at an earlier time and date ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتعديل الحجوزات التي تحتوي على مدفوعات أقل من المبلغ الإجمالي للحجز',
                    'en' => 'Allow modification of reservations that contain payments less than the total amount of the reservation ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'إخفاء الحجز الملغى',
                    'en' => 'Hide canceled reservation ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام الغرف',
                    'en' => 'Allowing the use of rooms ',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'تذكير تلقائي قبل الحجز',
                    'en' => 'Automatic reminder before booking',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'عدد دقائف التذكير تلقائي قبل الحجز',
                    'en' => 'Automatic reminder number of minutes before booking',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'تحقق من خدمة التداخل في المعاملات',
                    'en' => 'Check for overlapping service transactions',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'أضف رسوم إضافية على أقل حد أدنى لطلبات من المنزل',
                    'en' => 'Add additional fees for minimum take-home orders',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'الحد الأدنى لقيمة الطلب المقبولة',
                    'en' => 'Minimum acceptable order value',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'عدد دقائق للخدمات',
                    'en' => 'Number of minutes for services',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'رسوم التوصيل',
                    'en' => 'Delivery Charge',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'الحجز في اليوم التالي',
                    'en' => 'Booking for the next day',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض إشعارات الحجوزات في كل الصفحات',
                    'en' => 'Allow reservations notifications to be displayed on all pages',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام نظام التحقق عند التعامل مع الحجوزات',
                    'en' => 'Allow the use of the verification system when dealing with reservations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 16,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض الإحصائيات في الشاشة الرئيسية',
                    'en' => 'Allow statistics to be displayed on the home screen',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 18,
            ],
            [
                'name' => [
                    'ar' => 'السماح بالتخطي التحقق',
                    'en' => 'Allow skipping verification',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 18,
            ],
            [
                'name' => [
                    'ar' => 'تأثير الصرف والأستلام للخدمات',
                    'en' => 'Allow skipping verification',
                ],
                'rules' => 'required|between:0,2',
                'branch_main_settings_id' => 19,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام صور الخدمات',
                    'en' => 'Allow the use of images of services',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 19,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام الملاحظات علي صور الخدمات في المبيعات',
                    'en' => 'Allowing the use of notes on images of services in sales',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 19,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض صور الخدمات',
                    'en' => 'Allow images of services to be displayed',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 19,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض ملاحظات صور الخدمات',
                    'en' => 'Allow service image notes to be displayed',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 19,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام موظفي الخدمات في البيع و الحجز',
                    'en' => 'Allowing the use of service personnel in sales and reservations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 19,
            ],
            [
                'name' => [
                    'ar' => 'السماح بتكرار الخدمات في البيع و الحجز',
                    'en' => 'Allowing the repetition of services in sales and reservations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 19,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام المنتجات السريعة في المبيعات و الحجوزات',
                    'en' => 'Allowing the use of express products in sales and reservations',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 20,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإضافة المنتج آليا الي الفاتورة عندما تكون نتيجة البحث منتج واحد فقط',
                    'en' => 'Allowing the product to be added automatically to the invoice when the search result is only one product',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 20,
            ],
            [
                'name' => [
                    'ar' => 'لغه طباعة الفاتورة الرئيسيه',
                    'en' => 'Main invoice printing language',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'لغه طباعة فاتورة الموظفين',
                    'en' => 'Employee invoice printing language',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام الطباعة',
                    'en' => 'Allow the use of printing',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'عنوان فاتورة البيع بالعربى',
                    'en' => 'Sales invoice address in Arabic',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'عنوان فاتورة البيع بالإنجليزى',
                    'en' => 'Sales invoice address in English',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'عنوان فاتورة المرتجع بالعربى',
                    'en' => 'Return invoice address in Arabic',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'عنوان فانورة المرتجع بالانجليزى',
                    'en' => 'Fanoora return address in English',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'استلام الطباعة - نص الاعلان',
                    'en' => 'Print receipt - advertisement text',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 21,
            ],
            // [
            //     'name' => [
            //         'ar' => 'ظهور اللوجو فى الفاتورة',
            //         'en' => 'The logo appears on the invoice',
            //     ],
            //     'rules' => 'required|in:off,on',
            //     'branch_main_settings_id' => 21,
            // ],
            // [
            //     'name' => [
            //         'ar' => 'تحميل لوجو للفاتورة',
            //         'en' => 'Download the invoice logo',
            //     ],
            //     'rules' => 'required|string',
            //     'branch_main_settings_id' => 21,
            // ],
            // [
            //     'name' => [
            //         'ar' => 'ظهور Qr فى الفاتورة',
            //         'en' => 'Qr appears on the invoice',
            //     ],
            //     'rules' => 'required|in:off,on',
            //     'branch_main_settings_id' => 21,
            // ],
            [
                'name' => [
                    'ar' => 'طريقة عرض الموظفين',
                    'en' => 'Staff view',
                ],
                'rules' => 'required|between:0,2',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'ظهور صور الخدمات في الفاتورة',
                    'en' => 'Pictures of services appear in the invoice',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'استلام الطباعة - قم بتضمين أرقام هاتف العميل',
                    'en' => 'Print Receipt - Include customer phone numbers',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'السماح بالطباعة بعد انشاء عملية البيع',
                    'en' => 'Allow printing after creating the sale',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'السماح بالطباعة بعد انشاء الحجز',
                    'en' => 'Allow printing after creating the reservation',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'السؤال قبل الطباعة',
                    'en' => 'Question before printing',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض أسعار العناصر في طباعة الموظفين',
                    'en' => 'To allow item prices to be displayed in employee printing',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام Qr Code',
                    'en' => 'Allow the use of Qr Code',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'السماح بإستخدام رقم الطباعة في الفواتير',
                    'en' => 'Allow the use of the printing number in invoices',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'السماح بعرض رقم الطباعة في الفواتير',
                    'en' => 'Allow printing number to be displayed in invoices',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 21,
            ],
            [
                'name' => [
                    'ar' => 'محتوى العقد',
                    'en' => 'Contract content',
                ],
                'rules' => 'required|string',
                'branch_main_settings_id' => 21,
            ],

            [
                'name' => [
                    'ar' => 'السماح باستخدام أجهزة الدفع في المبيعات',
                    'en' => 'Allowing the use of payment devices in sales',
                ],
                'rules' => 'required|in:off,on',
                'branch_main_settings_id' => 23,
            ],

        ];

        foreach ($sub_settings as  $value) {
            BranchSubSettings::create($value);
        }
    }
}
