<?php

namespace Database\Seeders;

use App\Models\Level;
use Illuminate\Database\Seeder;

class LevelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $levels = [
            [
                'name' => [
                    'ar' => 'المستوي الاول',
                    'en' => 'level one',
                ],
                'digits' => 1,
            ],
            [
                'name' => [
                    'ar' => 'المستوي الثاني',
                    'en' => 'level two',
                ],
                'digits' => 3,
            ],
            [
                'name' => [
                    'ar' => 'المستوي الثالث',
                    'en' => 'level tree',
                ],
                'digits' => 4,
            ],
            [
                'name' => [
                    'ar' => 'المستوي الرابع',
                    'en' => 'level four',
                ],
                'digits' => 4,
            ],
            [
                'name' => [
                    'ar' => 'المستوي الخامس',
                    'en' => 'level five',
                ],
                'digits' => 4,
            ],
            [
                'name' => [
                    'ar' => 'المستوي السادس',
                    'en' => 'level six',
                ],
                'digits' => 4,
            ],
            [
                'name' => [
                    'ar' => 'المستوي السابع',
                    'en' => 'level seven',
                ],
                'digits' => 4,
            ],
        ];

        foreach ($levels as $level) {
            Level::create($level);
        }
    }
}
