<?php

namespace Database\Seeders;

use App\Models\Address;
use App\Models\Country;
use App\Models\Job;
use App\Models\User;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $cities = Country::whereNotNull('city_id')->get();
        $jobs = Job::all();

        User::factory(20)->create([
            'address_id' => function () use ($cities) {

                Address::factory(1)->create([
                    'area_id' => $cities->random()->id,
                    'address_line' => [
                        'ar' => fake()->paragraph(),
                        'en' => fake()->paragraph(),
                    ]
                ])->first()->id;
            },
            'job_id' => function () use ($jobs) {
                return  $jobs->random()->id;
            }
        ]);
    }
}
