<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Admin\Admin\AdminController;
use App\Http\Controllers\Api\Admin\Auth\AdminAuthController;
use App\Http\Controllers\Api\Admin\Auth\AdminProfileController;
use App\Http\Controllers\Api\Admin\Location\LocationController;
use App\Http\Controllers\Api\Admin\Package\PackageController;

Route::post('/login', [AdminAuthController::class, 'login']);

Route::group([
    'middleware' => 'auth:admin',
], function () {
    Route::post('/logout', [AdminAuthController::class, 'logout']);

    Route::group([
        'middleware' => 'auth:admin',
        'controller' => AdminProfileController::class,
        'prefix' => 'profile'
    ], function () {
        Route::get('/', 'show');
        Route::put('/', 'update');
        Route::patch('/change-password', 'changePassword');
    });

    Route::apiResource('/admins', AdminController::class);

    Route::put('/packages', [PackageController::class, 'changeStatus']);
    Route::apiResource('/packages', PackageController::class);
    Route::apiResource('/locations', LocationController::class);
});
