<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\MainUnitController;
use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\MainCurrencyController;
use App\Http\Controllers\Api\Account\AccountController;
use App\Http\Controllers\Api\Category\CategoryController;
use App\Http\Controllers\Api\Supplier\SupplierController;
use App\Http\Controllers\Api\Adminstration\TimeTypeController;
use App\Http\Controllers\Api\Location\LocationController;

Route::post('login', [LoginController::class, 'login']);
Route::get('locations', [LocationController::class, 'index']);
// Route::post('test-login', [LoginController::class, 'testLogin']);

// Route::group([
//     'prefix' => 'locations',
//     'controller' => LocationController::class,
// ], function () {
//     Route::get('/', 'index');
//     // Route::get('/countries', 'countries');
//     // Route::get('/countries/{country}', 'cities');
//     // Route::get('/cities/{area}', 'areas');
// });

Route::middleware(['auth:sanctum', 'secret-key-auth'])->group(function () {



    Route::group([
        'prefix' => 'user',
        'controller' => LoginController::class,
    ], function () {
        Route::get('/', 'loggedInUser');
        Route::post('/logout', 'logout');
    });

    Route::group([
        'prefix' => 'suppliers',
        'controller' => SupplierController::class,
        'middleware' => [
            'check-company-supplier'
        ],
    ], function () {
        Route::get('/',  'index')->withoutMiddleware('check-company-supplier');
        Route::post('/', 'store')->withoutMiddleware('check-company-supplier');
        Route::get('/{supplier}', 'show');
        Route::patch('/{supplier}', 'changeStatus');
        Route::put('/{supplier}',  'update');
        Route::delete('/{supplier}',  'destroy');
    });

    Route::group([
        'prefix' => '{type}/categories',
        'controller' => CategoryController::class,
    ], function () {
        Route::get('/',  'index');
        Route::post('/', 'store');
        Route::put('/{category}',  'update');
        Route::delete('/{category}',  'destroy');
    });

    Route::group([
        'prefix' => 'accounts',
        'controller' => AccountController::class,
        'middleware' => [
            'account-company'
        ],
    ], function () {
        Route::get('/search/',  'search');
        Route::get('/',  'index')->withoutMiddleware('account-company');
        Route::post('store/{account?}', 'store');
        Route::get('/{account}',  'show');
        Route::put('/{account}',  'update');
        Route::delete('/{account}',  'destroy');
    });

    // Route::group([
    //     'prefix' => 'companies',
    //     'controller' => CompanyController::class
    // ], function () {
    //     Route::get('/',  'index');
    //     Route::get('/{company}', 'show');
    //     Route::post('/', 'store');
    //     Route::put('/{company}',  'update');
    //     Route::delete('/{company}',  'destroy');
    // });

    Route::get('time-types', [TimeTypeController::class, 'index']);
    Route::get('main-units', [MainUnitController::class, 'index']);
    Route::get('main-currencies', [MainCurrencyController::class, 'index']);
});
