<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Branch\BranchController;
use App\Http\Controllers\Api\Branch\JobTypeController;
use App\Http\Controllers\Api\Branch\Delivery\DeliveryController;
use App\Http\Controllers\Api\Branch\DismissalNoticeController;
use App\Http\Controllers\Api\Branch\Warehouse\WarehouseController;
use App\Http\Controllers\Api\Branch\Setting\GroupSettingController;
use App\Http\Controllers\Api\Branch\Setting\GroupSubSettingController;
use App\Http\Controllers\Api\Branch\StockTransferController;
use App\Http\Controllers\Api\Branch\Warehouse\ProductWarehouseController;

Route::get('job-types', [JobTypeController::class, 'index']);
Route::group([
    'controller' => GroupSubSettingController::class,
    'prefix' => 'group-sub-settings',
    'middleware' => [
        'company-group-setting',
    ],
], function () {
    Route::get('/{groupSetting}/{branchMainSetting}', 'show');
    Route::post('/{groupSetting}/{branchMainSetting}', 'update');
});

Route::apiResource('deliveries', DeliveryController::class);
Route::apiResource('dismissal-notices', DismissalNoticeController::class)->except(['update']);
Route::apiResource('stock-transfers', StockTransferController::class)->except(['update']);


Route::group([
    'controller' => GroupSettingController::class,
    'prefix' => 'groups-setting',
    'middleware' => [
        'company-group-setting',
    ],
], function () {
    Route::get('/', 'index')->withoutMiddleware('company-group-setting');
    Route::post('/', 'store')->withoutMiddleware('company-group-setting');
    Route::get('/{groupSetting}', 'show');
    Route::put('/{groupSetting}', 'update');
    Route::delete('/{groupSetting}', 'destroy');
});

Route::get('/warehouses/{warehouse}/products/{product}', [ProductWarehouseController::class, 'show']);

Route::group([
    'controller' => WarehouseController::class,
    'prefix' => 'warehouses',
    'middleware' => [
        'company-warehouse',
    ],
], function () {
    Route::get('/', 'index')->withoutMiddleware('company-warehouse');
    Route::post('/', 'store')->withoutMiddleware('company-warehouse');
    Route::get('/{warehouse}', 'show');
    Route::put('/{warehouse}', 'update');
    Route::delete('/{warehouse}', 'destroy');
});

Route::group([
    'controller' => BranchController::class,
    // 'prefix' => 'groups-setting',
    'middleware' => [
        'branch-company',
    ],
], function () {
    Route::get('/', 'index')->withoutMiddleware('branch-company');
    Route::post('/', 'store')->withoutMiddleware('branch-company');
    Route::get('/employees/{branch}', 'branchEmployee')->withoutMiddleware('branch-company');
    Route::get('/{branch}', 'show');
    Route::put('/{branch}', 'update');
    Route::delete('/{branch}', 'destroy');
});

