<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class AttendMethods extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    public $translatable = ['name'];

    protected $guarded  = [];

    public function attendDetails()
    {
        return $this->hasMany(AttendDetail::class, 'attend_method_id');
    }

    public function employees()
    {
        return $this->hasMany(User::class, 'attend_method_id');
    }
}
