<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class AttendanceSetting extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'period_for_delay',
        'max_period_for_delay',
        'deduction_after_max_deliay',
        'deduction_for_first_absence',
        'deduction_for_second_absence',
        'permission_hours',
        'permission_numbers',
        'min_minutes_allowed',
        'max_minutes_allowed',
    ];

    public function deductions()
    {
        return $this->hasMany(Deduction::class);
    }
}
