<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;


class Branch extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    protected $fillable = ['employee_count_id', 'work_type_id', 'place', 'address_id', 'phone_one', 'phone_two', 'email', 'website', 'manager_fname', 'manager_lname', 'gender', 'home_service', 'beauty_expert', 'delivers'];

    public $translatable = ['place'];


    public function employeeCount()
    {
        return $this->belongsTo(DropdownOption::class, 'employee_count_id')->where('dropdown_name', 'employee_count');
    }

    public function workType()
    {
        return $this->belongsTo(DropdownOption::class, 'work_type_id')->where('dropdown_name', 'work_type');
    }

    public function address()
    {
        return $this->belongsTo(Address::class, 'address_id');
    }

    public function users()
    {
        return $this->morphedByMany(User::class, 'branchable');
    }

    public function warehouses()
    {
        return $this->hasMany(Warehouse::class);
    }
}
