<?php

namespace App\Models;

use App\Models\Service;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Category extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    protected $fillable = [
        'type',
        'name',
        'description',
        'internet_description',
        'status',
        'fast',
        'company_id',
    ];

    const RULES = [
        'type' => 'required|in:products_category,services_category',
        'name.ar' => 'required',
        'name.en' => 'required',
        'description'=> 'required',
        'description.ar' => 'required',
        'description.en' => 'required',
        'internet_description' => 'required',
        'status' => 'required',
        'fast' => 'required',
        'company_id' => 'required|exists:companies,id',

    ];

    public $translatable = [
        'name',
        'description',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function services()
    {
        return $this->hasMany(Service::class);
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }
}
