<?php

namespace App\Models;

use App\Models\User;
use App\Models\Address;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Client extends Model
{
    use HasFactory, SoftDeletes;

    const UPLOAD_PATH = 'uploads/images/clients/';

    const RULES = [
        'code' => 'nullable',
        'membership_number' => 'nullable',
        'title' => 'nullable',
        'name' => 'nullable',
        'phone' => 'nullable',
        'email' => 'nullable',
        'id_number' => 'nullable',
        'address_id' => 'nullable',
        'birth_date' => 'nullable',
        'work_phone' => 'nullable',
        'gender' => 'nullable',
        'job_name' => 'nullable',
        'favorite_employee_id' => 'nullable',
        'group_id' => 'nullable',
        'crn' => 'nullable', // Commercial Registration No
        'trn' => 'nullable', // Tax registration number
        'note' => 'nullable',
        'status' => 'nullable',
        'client' => 'nullable',
        'cache' => 'nullable',
        'internet' => 'nullable',
        'fingerprint' => 'nullable',
    ];

    protected $fillable = [
        'code',
        'membership_number',
        'title',
        'name',
        'phone',
        'email',
        'id_number',
        'address_id',
        'birth_date',
        'work_phone',
        'gender',
        'job_name',
        'favorite_employee_id',
        'group_id',
        'crn', // Commercial Registration No
        'trn', // Tax registration number
        'note',
        'status',
        'client',
        'cache',
        'internet',
        'fingerprint',
        'image',
    ];


    public function getGenderAttribute()
    {
        return $this->attributes['gender'] === 'male' ? 1 : 2;
    }


    public function address()
    {
        return $this->belongsTo(Address::class, 'address_id');
    }

    public function favoriteEmployee()
    {
        return $this->belongsTo(User::class, 'favorite_employee_id');
    }

    public function setCodeAttribute($value)
    {
        $this->attributes['code'] = 'c-' . $value;
    }
}
