<?php

namespace App\Models;

use Laravel\Sanctum\HasApiTokens;
// use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;


class Company extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasTranslations, SoftDeletes;
    //  HasRoles
    //  ;


    const UPLOADED_FILES = 'uploads/company';

    const ROLE = [
        'name.ar' => 'required',
        'name.en' => 'required',
        'password' => 'required',
    ];

    protected $guard = "company";

    protected $fillable = [
        'name',
        'email',
        'logo',
        'password',
        'phone',
    ];

    public $translatable = ['name'];

    protected $hidden = [
        'password',
    ];

    public function suppliers()
    {
        return $this->hasMany(Supplier::class);
    }

    public function categories()
    {
        return $this->hasMany(Category::class);
    }

    public function productsCategories()
    {
        return $this->hasMany(Category::class)
            ->where('type', 'products_category');
    }

    public function servicesCategories()
    {
        return $this->hasMany(Category::class)
            ->where('type', 'services_category');
    }

    // public function setPasswordAttribute($value)
    // {
    //     $this->attributes['password'] = Hash::make($value);
    // }

}
