<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['name', 'country_id', 'city_id'];

    function country() {
        return $this->belongsTo(Country::class, 'country_id');
    }

    function cities() {
        return $this->hasMany(Country::class, 'country_id');
    }

    function city() {
        return $this->belongsTo(Country::class, 'city_id');
    }

    function areas() {
        return $this->hasMany(Country::class, 'city_id');
    }

    function addresses() {
        return $this->hasMany(Address::class, 'area_id');
    }
}
