<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DropdownOption extends Model
{
    use HasFactory, SoftDeletes;



    public function employeeCounts()
    {
        return $this->hasMany(Branch::class, 'employee_count_id')->where('dropdown_name', 'employee_count');
    }

    public function workTypes()
    {
        return $this->belongsTo(Branch::class, 'work_type_id')->where('dropdown_name', 'work_type');
    }

    public function warehouseType()
    {
        return $this->hasMany(Warehouse::class, 'type_id')->where('dropdown_name', 'warehouse_type');;
    }

    public function warehousePurpose()
    {
        return $this->hasMany(Warehouse::class, 'purpose_id')->where('dropdown_name', 'warehouse_purpose');;
    }
}
