<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeTransfer extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function employee()
    {
        return $this->belongsTo(User::class, 'employee_id')->where('role', 0);
    }

    public function previousBranch()
    {
        return $this->belongsTo(Branch::class, 'previous_branch_id');
    }
    
    public function nextBranch()
    {
        return $this->belongsTo(Branch::class, 'next_branch_id');
    }
}
