<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;


class Job extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    protected $table = 'jobs';

    protected $fillable = ['job_department_id', 'name', 'status'];

    public $translatable = ['name'];

    function jobDepartment() {
        return $this->belongsTo(JobDepartment::class);
    }
}
