<?php

namespace App\Models;

use App\Models\Category;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Product extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name' => 'required',
        'barcode' => 'required',
        'description' => 'required',
        'category_id' => 'required|exists:categories,id',
        'size' => 'required',
        'inventory_type_id' => 'required|exists:dropdown_options,id',
        'has_expiry_date' => 'required',
    ];

    protected $fillable = [
        'code',
        'name',
        'barcode',
        'description',
        'category_id',
        'size',
        'inventory_type_id',
        'has_expiry_date',
    ];

    public $translatable = [
        'name',
        'description',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

}
