<?php

namespace App\Models;

use App\Models\Category;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Translatable\HasTranslations;

class Service extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'category_id' => 'required|exists:categories,id',
        'name' => 'required',
        'name_ar' => 'required',
        'name_en' => 'required',
        'description' => 'required',
        'description_ar' => 'required',
        'description_en' => 'required',
        'fast' => 'required',
        'status' => 'required',
    ];

    protected $fillable = [
        'code',
        'category_id',
        'name',
        'description',
        'fast',
        'status',
    ];

    public $translatable = [
        'name',
        'description',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}
