<?php

namespace App\Models;

use App\Models\Address;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Supplier extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    const ROLES = [
        'code' => 'required',
        'name.ar' => 'required',
        'name.en' => 'required',
        'phone' => 'required',
        'phone_2' => 'nullable',
        // 'address_id' => 'required',
        'note' => 'nullable',
        'status' => 'required',
        'company_id' => 'required|exists:companies,id',

    ];

    protected $fillable = [
        'code',
        'name',
        'phone',
        'phone_2',
        'address_id',
        'note',
        'status',
        'company_id',
    ];

    public $translatable = ['name'];

    public function address()
    {
        return $this->belongsTo(Address::class, 'address_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    // public function getCodeAttribute($value)
    // {
    //     return 's-' . $value;
    // }
}
