<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{
    use HasFactory, SoftDeletes;

    const RULES = [
        'name.ar' => 'required|string',
        'name.en' => 'required|string',
        'type_id' => 'required',
        'purpose_id' => 'required',
        'status' => 'required',
    ];


    protected $fillable = [
        'code',
        'name',
        'type_id',
        'status',
        'purpose_id'
    ];

    // public function branch()
    // {
    //     return $this->belongsTo(Branch::class);
    // }

    public function type()
    {
        return $this->belongsTo(DropdownOption::class, 'type_id')->where('dropdown_name', 'warehouse_type');;
    }

    public function purpose()
    {
        return $this->belongsTo(DropdownOption::class, 'id', 'purpose_id');
    }

    public function setCodeAttribute($value)
    {
        $this->attributes['code'] = 'w-' . $value;
    }
}
