<?php
namespace App\Trait;

trait ApiTrait
{
    public function apiResponse($code = true, $message = null, $errors = [], $data = [])
    {
        $array = [
            'status'  => $code,
            'message' => $message,
        ];
        if (is_null($data) && !is_null($errors)) {
            foreach($errors as $key => $val)
            {
                $array['errors'][$key] = $val[0];

            }
        } elseif (!is_null($data) && is_null($errors)) {
            $array['data'] = $data;
        } else {
            $array['data'] = $data;
            $array['errors'] = $errors;
        }

        return response()->json($array, 200);
    }
}
